#!/usr/bin/env python 

import os
import sqlite3
import json 

class HypernymManager(object):

    def __init__(self, db=None):
        if not db:
            fname = os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                 './data/dannet.db')
            db = sqlite3.connect(fname)
 
        self.conn = db
        self.cursor = db.cursor()

        fname = os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                 './data/hypernymdb.json')
        with open(fname, 'r') as f:
            self.lookup = json.load(f)

    def get_synset_ids_from_word(self, word):
        """
        Pick up primary meaning
        """
        sql = 'SELECT synset_id FROM words, words_synsets, synsets \
            WHERE form = ? AND words.id = words_synsets.word_id AND synsets.id=synset_id \
            ORDER BY length(gloss), gloss'
        self.cursor.execute(sql, (word,))
        res = self.cursor.fetchall()
        synset_ids = [x[0] for x in res]
        return synset_ids


    def get_words_from_synset(self, synset_id):
        sql = 'SELECT form FROM words as w, words_synsets as ws \
            WHERE ws.synset_id = {} AND w.id = ws.word_id'.format(synset_id)
        self.cursor.execute(sql)
        res = self.cursor.fetchall()
        words = [x[0] for x in res]

        return words

    def get_hypernym_ids_from_synset_id(self, synset_id):
        sql = 'SELECT value FROM relations WHERE synset_id={} AND name="hyponymOf"'.format(synset_id)
        self.cursor.execute(sql)
        res = self.cursor.fetchall()
        hypernym_ids = [x[0] for x in res]
        return hypernym_ids

    def get_hypernyms_from_synset_id(self, synset_id):
        hypernym_ids = self.get_hypernym_ids_from_synset_id(synset_id)
        words = []
        for hypernym_id in hypernym_ids:
            hypernym_words = self.get_words_from_synset(hypernym_id)
            words.extend(hypernym_words)
        return words


    def get_hypernyms(self, word):
        return self.lookup.get(word)


def main(word):
    """ 
    Pick up hypernyms, usage:
    hypernyms.py word
    """

    hypernymdb = HypernymManager()
    words = hypernymdb.get_hypernyms(word)
    print(words)

if __name__ == '__main__':
    import plac; plac.call(main)

