# -*- coding: utf-8 -*-
import requests
import json
import logging
from datetime import datetime

LOGGER = logging.getLogger(__name__)


class SMKApi(object):
    """ Fetches artworks from smk api """
    API = 'https://api.smk.dk/api/v1'

    def __init__(self, api=None):
        if api:
            self.API = api

    def art(self, object_number, dc=None, jsonld=None, jsonld_type=None):
        """ """
        url = f'{self.API}/art/'
        params = dict(
            object_number=object_number,
            cachebusting=datetime.now().timestamp())
        if dc is not None:
            params['dc'] = dc
        if jsonld is not None:
            params['jsonld'] = jsonld
        if jsonld_type is not None:
            params['jsonld_type'] = jsonld_type
        resp = requests.get(url, params=params)
        resp.raise_for_status()
        return resp.json()

    def search(self, keys, jsonld_type=None, qfields=None, fields=None,
               facets=None, range=None, filters=None, sort=None,
               sort_type=None, offset=None, rows=None, lang=None):
        url = f'{self.API}/art/search'
        params = {'keys': keys}

        if jsonld_type is not None:
            params['jsonld_type'] = jsonld_type
        if qfields is not None:
            params['qfields'] = ','.join(qfields)
        if fields is not None:
            params['fields'] = ','.join(fields)
        if facets is not None:
            params['facets'] = ','.join(facets)
        if range is not None:
            params['range'] = ','.join(range)
        if filters is not None:
            params['filters'] = ','.join(filters)
        if sort is not None:
            params['sort'] = sort
        if sort_type is not None:
            params['sort_type'] = sort_type
        if offset is not None:
            params['offset'] = offset
        if rows is not None:
            params['rows'] = rows
        if lang is not None:
            params['lang'] = lang
        resp = requests.get(url, params=params)
        resp.raise_for_status()
        return resp.json()

    def all(self, keys, jsonld_type=None, qfields=None, fields=None,
            facets=None, range=None, filters=None, sort=None,
            sort_type=None, lang=None):
        rows = 1000
        offset = 0
        total = 1

        while offset < total:
            print(f'offset {offset}, total {total}')
            res = self.search(
                keys=keys, jsonld_type=jsonld_type, qfields=qfields,
                fields=fields, facets=facets, range=range, filters=filters,
                sort=sort, sort_type=sort_type,
                offset=offset, rows=rows, lang=lang)
            total = int(res.get('found'))
            print(f'got {len(res.get("items"))} results')

            for item in res.get('items', ()):
                yield item

            offset = offset + rows
