# -*- coding: utf-8 -*-
import pysolr
import requests
import logging

LOGGER = logging.getLogger(__name__)

configset = '_default'


class SolrCoreManager(object):

    def __init__(self, url, core, configset=configset):
        self.url = url
        self.core = core
        self.configset = configset
        self.api = f'{url}/admin/cores'

    def get_connection(self):
        if not self.core_exists():
            LOGGER.info('Solr core "%s" does not exist.', self.core)
            self.core_create()
        else:
            LOGGER.info('Solr core "%s" found.', self.core)

        return pysolr.Solr(f'{self.url}/{self.core}')

    def core_exists(self):
        status = requests.get(f'{self.api}?action=STATUS')
        return (self.core in status.json()['status'].keys())

    def core_create(self):
        resp = requests.get(
            f'{self.api}?action=CREATE&name={self.core}&configSet={configset}'
        )
        LOGGER.info('Created new Solr core "%s".', self.core)
